<?php $__env->startSection('content'); ?>
<div class="content-wrapper">
	<div class="content pt-3">
		<div class="container-fluid">
			<div class="row">
				<div class="col-12">
					<div class="card border-0 shadow-custom">
						<div class="card-header border-grey">
							<h3 class="card-title">
								<?php echo e(__('reports.payment_title')); ?>

							</h3>
						</div>
						<div class="card-body">
							<div class="row">
								<div class="col-md-12 d-flex justify-content-between">
									<div class="report-btns">
										<a href="<?php echo e(route('reports.payment_transactions', ['type' => 'csv'] )); ?>"
											class="btn btn-default">
											<i class="fas fa-file-csv"></i> <?php echo e(__('reports.export')); ?>

										</a>
										<a href="<?php echo e(route('reports.payment_transactions', ['type' => 'print'] )); ?>"
											rel="noopener" target="_blank" class="btn btn-default">
											<i class="fas fa-print"></i> <?php echo e(__('reports.print')); ?>

										</a>
									</div>
									<form class="w-25" method="post"
										action="<?php echo e(route('reports.payment_transactions')); ?>">
										<?php echo e(csrf_field()); ?>

										<div class="input-group mb-3">
											<select class="form-control " name="search" required>
												<option value="all" <?php echo e($keyword=="all" ? "selected" : ""); ?>>
													All
												</option>
												<option value="today" <?php echo e($keyword=="today" ? "selected" : ""); ?>>
													Today
												</option>
												<option value="this_week" <?php echo e($keyword=="this_week" ? "selected" : ""); ?>>
													This Week
												</option>
												<option value="this_month" <?php echo e($keyword=="this_month" ? "selected" : ""); ?>>
													This Month
												</option>
												<option value="last_month" <?php echo e($keyword=="last_month" ? "selected" : ""); ?>>
													Last Month
												</option>
												<option value="last_three_months" <?php echo e($keyword=="last_three_months"
													? "selected" : ""); ?>>
													Last 3 Months
												</option>
												<option value="last_six_months" <?php echo e($keyword=="last_six_months"
													? "selected" : ""); ?>>
													Last 6 Months
												</option>
												<option value="this_year" <?php echo e($keyword=="this_year" ? "selected" : ""); ?>>
													This Year
												</option>
												<option value="last_year" <?php echo e($keyword=="last_year" ? "selected" : ""); ?>>
													Last Year
												</option>
											</select>
											<div class="input-group-append">
												<button class="btn btn-primary" type="submit"><i
														class="fas fa-search"></i></button>
											</div>
										</div>
									</form>
								</div>
								<div class="col-12">
									<div class="table-responsive">
										<table class="table custom-table-bordered table-hover">
											<thead>
												<tr>
													<th class="nowrap"><?php echo e(__('reports.th_name')); ?></th>
													<th><?php echo e(__('reports.th_amount')); ?></th>
													<th class="nowrap"><?php echo e(__('reports.th_payment_date')); ?></th>
													<th class="nowrap"><?php echo e(__('reports.th_transaction_type')); ?></th>
													<th class="nowrap"><?php echo e(__('reports.th_dr_cr')); ?></th>
													<th class="nowrap"><?php echo e(__('reports.th_payment_method')); ?></th>
													<th class="fixed-width-td"><?php echo e(__('reports.th_details')); ?></th>
												</tr>
											</thead>
											<tbody>
												<?php $__currentLoopData = $payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
												<tr>
													<td class="align-middle nowrap">
														<?php echo e(transaction_name($payment)); ?>

													</td>
													<td class="align-middle">
														<?php echo transaction_type($payment); ?>

													</td>
													<td class="align-middle nowrap">
														<?php echo e(format_date($payment->date)); ?>

													</td>
													<td class="align-middle nowrap text-capitalize">
														<?php echo e($payment->type); ?>

													</td>
													<td class="align-middle nowrap text-capitalize">
														<?php echo e($payment->dr_cr); ?>

													</td>
													<td class="align-middle nowrap text-capitalize">
														<?php echo e($payment->method); ?>

													</td>
													<td class="align-middle nowrap">
														<?php echo e($payment->note); ?>

													</td>
												</tr>
												<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
												<?php if(count($payments) == 0): ?>
												<tr>
													<td colspan="11">
														<p class="text-center mb-0"><?php echo e(__('reports.no_record_found')); ?>

														</p>
													</td>
												</tr>
												<?php endif; ?>
											</tbody>
										</table>
									</div>
								</div>
								<div class="col-12">
									<div class="d-flex justify-content-end">
										<?php if($paginate): ?>
										<?php echo e($payments->links()); ?>

										<?php endif; ?>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/resources/views/reports/payment_transaction.blade.php ENDPATH**/ ?>